<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Contacts extends Model 
{

    protected $table = 'contacts';
    public $timestamps = true;
    protected $fillable = array('contact_first_name', 'contact_last_name', 'contact_title', 'contact_email', 'contactable_type');
    protected $visible = array('contact_first_name', 'contact_last_name', 'contact_title', 'contact_email', 'contactable_type');

    public function contactable()
    {
        return $this->morphTo();
    }

    public function phone_numbers()
    {
        return $this->hasMany('App\Models\PhoneNumber', 'contact_id');
    }

}